import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;


public class parser2 implements ActionListener
{
   private JTextArea input;
   private JTextArea output;
   
   public static void main(String[] args)
   {
      javax.swing.SwingUtilities.invokeLater(new Runnable() {
         public void run() {
            JFrame.setDefaultLookAndFeelDecorated(true);
            parser2 p = new parser2();
         }
      });
   }
   
   
   public parser2()
   {
      JFrame frame = new JFrame("tracert parser");
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      
      JPanel panel = new JPanel(new GridLayout(1,2));
      input = new JTextArea();
      output = new JTextArea();
      JButton button = new JButton("Parse");
      
      button.addActionListener(this);
      
      panel.add(new JScrollPane(input));
      panel.add(new JScrollPane(output));
      frame.getContentPane().add(panel, BorderLayout.CENTER);
      frame.getContentPane().add(button, BorderLayout.SOUTH);
      
      frame.setSize(new Dimension(400,500));
      frame.setVisible(true);
   }
   
   
   public void actionPerformed(ActionEvent event) 
   {
      output.setText("");
      try 
      {
         // Fetch the input contents
         String inputData = input.getText();
         // Loop through each line in the contents
         for (int i=0; i < input.getLineCount(); i++)
         {
            // Fetch the string data
            int start = input.getLineStartOffset(i);
            int end = input.getLineEndOffset(i);
            String line = inputData.substring(start, end);
            
            // Tokenize the line (using default space as the separator)
            StringTokenizer st = new StringTokenizer(line);
            // Make sure there's a few tokens
            if (st.countTokens() > 3)
            {
               // Get the tokens for the line
               int j = 0;
               float lineVal = 0;
               boolean timedOut = false;
               while (st.hasMoreTokens())
               {
                  // We only want the tokens that represent times
                  String token = st.nextToken();
                  if (j == 4)
                  {
                     String time = token.substring( token.indexOf("=")+1, token.length()-2 );
                     output.append( time + "\n" );
                  }
                  
                  j = j+1;
               }
            }
            
            // We get exactly 3 when we get a "Request Timed Out"
            else if (st.countTokens() == 3)
            {
               output.append( "999\n" );
            }
         }
      } 
      catch(Exception e)
      {
         System.err.println(e.toString());
      }
   }
   
}